CREATE VIEW "SBODEMODE"."SBO_FI_PC_01" ( "PROFIT_CTR", "SBOPFT_COD", "CRM_DIRECT", "AC_DOC_NO", "GL_ACCOUNT", "CALDAY", "ACCT_TYPE", "DEBIT", "CREDIT", "CURRENCY" ) AS SELECT TO_CHAR(P."PrcCode") as "PROFIT_CTR",
	 			TO_CHAR(P."OcrCode") as "SBOPFT_COD",
	 			P."Direct"  as "CRM_DIRECT",
	 			J."TransId" as "AC_DOC_NO",
	 			left(J."Account", 10) as "GL_ACCOUNT",
				TO_CHAR(YEAR(J."RefDate"))		
       				|| case LENGTH(MONTH(J."RefDate"))	
          			when 1 then '0' || TO_CHAR(MONTH(J."RefDate"))
          			else TO_CHAR(MONTH(J."RefDate"))
        		 end	
      				|| case LENGTH(TO_CHAR(EXTRACT(DAY FROM J."RefDate")))
          			when 1 then '0' || TO_CHAR(EXTRACT(DAY FROM J."RefDate"))
          			else TO_CHAR(EXTRACT(DAY FROM J."RefDate"))
        		end  	
				as "CALDAY",
				A."ActType" as "ACCT_TYPE",
				J."Debit" * (P."PrcAmount"/P."OcrTotal") as "DEBIT",
				J."Credit" * (P."PrcAmount"/P."OcrTotal") as "CREDIT",
				CASE A."ActCurr" 		
          			WHEN '€' THEN 'EUR'	
					WHEN '##' THEN 'EUR'
					WHEN '$' THEN 'USD'
          			ELSE A."ActCurr" 	
      			END		
				AS "CURRENCY"	
				FROM (OCR1 as P  INNER JOIN JDT1 as J  ON P."OcrCode"=J."ProfitCode")   
				INNER JOIN OACT as A ON A."AcctCode"=J."Account" WITH READ ONLY